<?php

namespace App\Imports\Site;

use App\Models\Image\Photo;
use App\Models\Site\Student\StudentHistoryExcel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Intervention\Image\Facades\Image;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
 use PhpOffice\PhpSpreadsheet\Shared\Date;
use PHPExcel_Shared_Date;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use PhpOffice\PhpSpreadsheet\IOFactory;




class SiteStudentListImport implements ToModel, WithHeadingRow
{
    private $rows = 0;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */


    public function model(array $row)
    {

        
        if ($row['student_name']) {


            $data = StudentHistoryExcel::where('student_name', $row['student_name'])
                ->where('mobile', $row['mobile'])
                ->first();
            if (empty($data)) {
                ++$this->rows;
                $imageData = base64_decode($row['image']);
                dd($imageData);

                if (isset($row['image'])) {
                    $image_path = 'uploads/' . Str::uuid() . '.jpg';
                    Storage::put($image_path, $row['image']);
                } else {
                    $image_path = null;
                }

                


                    // $excelDate = $row['date_of_birth']; //2018-11-03
                    // $miliseconds = ($excelDate - (25567 + 2)) * 86400 * 1000;
                    // $seconds = $miliseconds / 1000;
                return new StudentHistoryExcel([

//                    'photo_path' => $photo->path ,

                    'student_name' => $row['student_name'],
                    'father_name' => $row['father_name'],
                    'mother_name' => $row['mother_name'],
                    'roll_number' => $row['roll_number'],
                    'student_id' => $row['student_id'],
              //      'date_of_birth' =>date("Y-m-d", $seconds),
                    'date_of_birth' =>$row['date_of_birth'],

                    'shift' => $row['shift'],
                    'gender' => $row['gender'],
                    'mobile' => $row['mobile'],
                    'board_registration_number' => $row['board_registration_number'],
                    'site_id' => \Session::get('SITE_ID'),
                    'image_path' => $image_path,

                ]);
            }
        }

    }


    public function getRowCount(): int
    {
        return $this->rows;
    }
}
